@extends('layouts.admin')

@section('title', 'View Service')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Service Details</h1>
    <div>
        <a href="{{ route('admin.services.edit', $service) }}" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('admin.services.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="text-center mb-4">
            @if($service->icon)
                <i class="{{ $service->icon }}" style="font-size: 5rem; color: var(--primary-color);"></i>
            @endif
        </div>
        <h2>{{ $service->name }}</h2>
        <p class="text-muted">Slug: <code>{{ $service->slug }}</code></p>
        <p class="lead">{{ $service->description }}</p>
        @if($service->full_description)
        <div class="mt-4">
            <h4>Full Description</h4>
            <p>{{ $service->full_description }}</p>
        </div>
        @endif
        <div class="mt-4">
            <p><strong>Sort Order:</strong> {{ $service->sort_order }}</p>
            <p>
                <strong>Status:</strong> 
                <span class="badge bg-{{ $service->is_active ? 'success' : 'secondary' }}">
                    {{ $service->is_active ? 'Active' : 'Inactive' }}
                </span>
            </p>
        </div>
    </div>
</div>
@endsection



